/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle.packs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.registry.particle.packs.SimpleRuneColorPack;
import com.redpxnda.respawnobelisks.util.ClientUtils;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RainbowPack
extends SimpleRuneColorPack {
    public RainbowPack() {
        this.ticks = 200;
        this.colors.add(new float[]{255.0f, 0.0f, 0.0f});
        this.colors.add(new float[]{255.0f, 255.0f, 0.0f});
        this.colors.add(new float[]{0.0f, 255.0f, 0.0f});
        this.colors.add(new float[]{0.0f, 255.0f, 255.0f});
        this.colors.add(new float[]{0.0f, 0.0f, 255.0f});
        this.colors.add(new float[]{255.0f, 0.0f, 255.0f});
    }

    @Override
    public boolean obeliskRenderTick(RespawnObeliskBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        Level level = blockEntity.m_58904_();
        if (level != null && level.m_46467_() - blockEntity.getLastCharge() <= 60L) {
            int time = (int)(level.m_46467_() - blockEntity.getLastCharge());
            if (time <= 50) {
                RenderUtils.renderRainbow((float)time / 50.0f, 1.0f, blockEntity, stack, RenderUtils.getAtlasSprite("rainbow"), buffer, light);
            } else {
                RenderUtils.renderRainbow(1.0f, (float)(60 - time) / 10.0f, blockEntity, stack, RenderUtils.getAtlasSprite("rainbow"), buffer, light);
            }
            if (time % 5 == 0 && time < 50) {
                if (!ClientUtils.hasTracker("rainbow_pack_sound_ticker") || ClientUtils.getTracker("rainbow_pack_sound_ticker") != time) {
                    BlockPos pos = blockEntity.m_58899_();
                    level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12211_, SoundSource.BLOCKS, 1.0f, (float)time / 50.0f + 0.5f, false);
                }
                ClientUtils.setTracker("rainbow_pack_sound_ticker", time);
            }
        }
        return false;
    }

    @Override
    public void depleteAnimation(Level level, Player player, BlockPos blockPos) {
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 360; i += 12) {
                double rad = (double)i * Math.PI / 180.0;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)blockPos.m_123341_() + 0.5 + Math.sin(rad) * (double)j / 5.0, (double)blockPos.m_123342_() + 2.5, (double)blockPos.m_123343_() + 0.5 + Math.cos(rad) * (double)j / 5.0, 0.0, 0.0, 0.0);
                if (i % 36 != 0) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, (double)blockPos.m_123341_() + 0.5 + Math.sin(rad) * (double)j / 5.0, (double)blockPos.m_123342_() + 2.49, (double)blockPos.m_123343_() + 0.5 + Math.cos(rad) * (double)j / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public SoundEvent depleteSound() {
        return SoundEvents.f_144242_;
    }

    @Override
    public SoundEvent chargeSound() {
        return null;
    }
}

